/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.logon;

import com.ibm.hwmca.base.logon.LogonConstants;
import com.ibm.hwmca.base.logon.LogonErrorIds;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.PasswordValidation;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;

public class ChangeHMCPasswordBean
extends PanelBean
implements LogonConstants,
LogonErrorIds {
    private static final String TRACE_MASKT = "XLGNPAST";
    private static final String TRACE_MASKF = "XLGNPASF";
    private static final String TRACE_MASKD = "XLGNPASD";
    private static final String PASSWORD_MESSAGES_FILENAME = "com.ibm.hwmca.base.res.message";
    private static final String PASSWORD_REQUIRED_ERROR_TEXT = "LGN.LOGON.REQUIRED.PASSWORD.ERROR.TEXT";
    private static final String INVALID_PASSWORD_ERROR_START_TEXT = "LGN.LOGON.INVALID.PASSWORD.BEGIN.TEXT";
    private static final String INVALID_PASSWORD_ERROR_MIDDLE_TEXT = "LGN.LOGON.INVALID.PASSWORD.MIDDLE.TEXT";
    private static final String INVALID_PASSWORD_ERROR_END_TEXT = "LGN.LOGON.INVALID.PASSWORD.END.TEXT";
    private static final String PASSWORD_CHANGE_FAILED_TITLE = "LGN.PASSWORD.CHANGE.FAILED.TITLE";
    private static final String PASSWORD_CHANGE_FAILED_TEXT = "LGN.PASSWORD.CHANGE.FAILED.TEXT";
    private boolean m_bStrictRulesToggle;
    private String m_sPassword1Edit;
    private String m_sPassword2Edit;

    public String getPassword1Edit() {
        Trace.trace(TRACE_MASKT, "<> ChangeHMCPasswordBean.getPassword1Edit()");
        return this.m_sPassword1Edit;
    }

    public void setPassword1Edit(String password1) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> ChangeHMCPasswordBean.setPassword1Edit()");
        if (password1.length() > 0) {
            if (password1.length() < 6 || password1.length() > 32) {
                this.load();
                this.userTaskManager.refreshElement(this.getMountPrefix() + "Password1Edit");
                this.userTaskManager.refreshElement(this.getMountPrefix() + "Password2Edit");
                throw new IllegalUserDataException(new LocalizableText(PASSWORD_MESSAGES_FILENAME, INVALID_PASSWORD_ERROR_START_TEXT).toString() + " " + 6 + " " + new LocalizableText(PASSWORD_MESSAGES_FILENAME, INVALID_PASSWORD_ERROR_MIDDLE_TEXT).toString() + " " + 32 + " " + new LocalizableText(PASSWORD_MESSAGES_FILENAME, INVALID_PASSWORD_ERROR_END_TEXT).toString());
            }
        } else {
            this.load();
            this.userTaskManager.refreshElement(this.getMountPrefix() + "Password1Edit");
            this.userTaskManager.refreshElement(this.getMountPrefix() + "Password2Edit");
            throw new IllegalUserDataException(new LocalizableText(PASSWORD_MESSAGES_FILENAME, PASSWORD_REQUIRED_ERROR_TEXT).toString());
        }
        this.m_sPassword1Edit = password1.toUpperCase();
        Trace.trace(TRACE_MASKT, "<- ChangeHMCPasswordBean.setPassword1Edit()");
    }

    public String getPassword2Edit() {
        Trace.trace(TRACE_MASKT, "<> ChangeHMCPasswordBean.getPassword2Edit()");
        return this.m_sPassword2Edit;
    }

    public void setPassword2Edit(String password2) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> ChangeHMCPasswordBean.setPassword2Edit()");
        if (password2.length() > 0) {
            if (password2.length() < 6 || password2.length() > 32) {
                this.m_sPassword2Edit = "";
                this.userTaskManager.refreshElement(this.getMountPrefix() + "Password2Edit");
                throw new IllegalUserDataException(new LocalizableText(PASSWORD_MESSAGES_FILENAME, INVALID_PASSWORD_ERROR_START_TEXT).toString() + " " + 6 + " " + new LocalizableText(PASSWORD_MESSAGES_FILENAME, INVALID_PASSWORD_ERROR_MIDDLE_TEXT).toString() + " " + 32 + " " + new LocalizableText(PASSWORD_MESSAGES_FILENAME, INVALID_PASSWORD_ERROR_END_TEXT).toString());
            }
        } else {
            this.m_sPassword2Edit = "";
            this.userTaskManager.refreshElement(this.getMountPrefix() + "Password1Edit");
            throw new IllegalUserDataException(new LocalizableText(PASSWORD_MESSAGES_FILENAME, PASSWORD_REQUIRED_ERROR_TEXT).toString());
        }
        this.m_sPassword2Edit = password2.toUpperCase();
        Trace.trace(TRACE_MASKT, "<- ChangeHMCPasswordBean.setPassword2Edit()");
    }

    public boolean isStrictRulesToggle() {
        Trace.trace(TRACE_MASKT, "<> ChangeHMCPasswordBean.isStrictRulesToggle()");
        return this.m_bStrictRulesToggle;
    }

    public void setStrictRulesToggle(boolean b) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> ChangeHMCPasswordBean.setStrictRulesToggle()");
        this.m_bStrictRulesToggle = b;
        Trace.trace(TRACE_MASKT, "<- ChangeHMCPasswordBean.setStrictRulesToggle()");
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "-> ChangeHMCPasswordBean.load()");
        this.m_sPassword1Edit = "";
        this.m_sPassword2Edit = "";
        Trace.trace(TRACE_MASKT, "<- ChangeHMCPasswordBean.load()");
    }

    public void verifyChanges() {
        Trace.trace(TRACE_MASKT, "<> ChangeHMCPasswordBean.verifyChanges()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "<> ChangeHMCPasswordBean.save()");
    }

    public void panelAction(TaskActionEvent event) {
        block12: {
            Trace.trace(TRACE_MASKT, "-> ChangeHMCPasswordBean.panelAction(" + event + ")");
            String elementName = event.getElementName();
            try {
                if (elementName.equals(this.getMountPrefix() + "ChangePasswordButton")) {
                    Trace.trace(TRACE_MASKF, "ChangeHMCPasswordBean.panelAction(): The change password button was pushed.");
                    this.userTaskManager.storeElement(this.getMountPrefix() + "Password1Edit");
                    this.userTaskManager.storeElement(this.getMountPrefix() + "Password2Edit");
                    String password1 = this.getPassword1Edit();
                    String password2 = this.getPassword2Edit();
                    if (this.isStrictRulesToggle()) {
                        if (PasswordValidation.isPasswordValid(password1)) {
                            PanelTaskletRequest request = new PanelTaskletRequest();
                            request.setData("SOURCE", "ChangeHMCPasswordPanel");
                            request.setData("EVENT", event);
                            request.setData("PASSWORD", password1);
                            this.postTaskletRequest(request);
                        } else {
                            this.load();
                            this.userTaskManager.refreshElement(this.getMountPrefix() + "Password1Edit");
                            this.userTaskManager.refreshElement(this.getMountPrefix() + "Password2Edit");
                        }
                        break block12;
                    }
                    if (password1.equals(password2)) {
                        PanelTaskletRequest request = new PanelTaskletRequest();
                        request.setData("SOURCE", "ChangeHMCPasswordPanel");
                        request.setData("EVENT", event);
                        request.setData("PASSWORD", password1);
                        this.postTaskletRequest(request);
                        break block12;
                    }
                    try {
                        CommonMsgApp.showMessageBox(this.userTaskManager, new LocalizableText(PASSWORD_MESSAGES_FILENAME, PASSWORD_CHANGE_FAILED_TITLE), new MessageText(PASSWORD_MESSAGES_FILENAME, PASSWORD_CHANGE_FAILED_TEXT));
                    }
                    catch (Exception exc) {
                        Trace.trace(TRACE_MASKF, exc);
                    }
                    this.load();
                    this.userTaskManager.refreshElement(this.getMountPrefix() + "Password1Edit");
                    this.userTaskManager.refreshElement(this.getMountPrefix() + "Password2Edit");
                    break block12;
                }
                if (elementName.equals(this.getMountPrefix() + "ResetButton")) {
                    Trace.trace(TRACE_MASKF, "ChangeHMCPasswordPanel.panelAction(): The reset button was pushed.");
                    this.load();
                    this.userTaskManager.refreshElement(this.getMountPrefix() + "Password1Edit");
                    this.userTaskManager.refreshElement(this.getMountPrefix() + "Password2Edit");
                } else if (elementName.equals(this.getMountPrefix() + "CancelButton")) {
                    Trace.trace(TRACE_MASKF, "ChangeHMCPasswordPanel.panelAction(): The cancel button was pushed.");
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setData("SOURCE", "ChangeHMCPasswordPanel");
                    request.setData("EVENT", event);
                    this.postTaskletRequest(request);
                }
            }
            catch (IllegalUserDataException iuExc) {
                Trace.trace(TRACE_MASKF, "ChangeHMCPasswordPanel.panelAction(): " + (Object)((Object)iuExc));
            }
        }
        Trace.trace(TRACE_MASKT, "<- ChangeHMCPasswordBean.panelAction()");
    }
}

